#!/usr/bin/env python
# -*- coding: UTF8 -*-
#********************************************************************************
#    BEGIN LICENSE BLOCK
#********************************************************************************
# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is DataFlowGenerator code.
#
# The Initial Developer of the Original Code is Arthur Torossian.
# Portions created by Arthur Torossian are Copyright (C) 2009 Arthur Torossian,
# living in Paris, 20 rue Sibuet, in 2009. All Rights Reserved.
#
# Original Author: Arthur Torossian (arthur.torossian@free.fr)
#
# Contributor(s): None
#
# Alternatively, the contents of this file may be used under the terms of the
# GNU Lesser General Public License (the  "LGPL License"), in which case the
# provisions of the LGPL License are applicable instead of those above.
# If you wish to allow use of your version of this file only under the terms
# of the LGPL License and not to allow others to use your version of this file
# under the MPL, indicate your decision by deleting  the provisions above and
# replace  them with the notice and other provisions required by the LGPL
# License.  If you do not delete the provisions above, a recipient may use
# your version of this file under either the MPL or the LGPL License.
#
# For more information about the LGPL: http://www.gnu.org/copyleft/lesser.html
#********************************************************************************
#    END LICENSE BLOCK
#********************************************************************************

################################################################################
# Project: genparser    XML driver
# Author:  Arthur TOROSSIAN
# by DataFlowGenerator (Arthur Torossian)
################################################################################
dfgBehaviourFileVersion="0.1.0"
import os, sys, re
import tuto01_XmlDrvClassDiagrBeHaviour
from tuto01_XmlDrvClassDiagrBeHaviour import register_creator, create, CFileFormatInfo, xmlBaseError, random
# dfg_start_include do not modify this line
# To manualy complete if necessary
import math
# dfg_end_include do not modify this line
################################################################################
# CBase
################################################################################
# dfg_start_class do not modify this line
class CBase : # ancestors :  xmlBase
    pass
#-------------------------------------------------------------------------------
    # dfg_start_def do not modify this line
    def calcDimension( self  ) : #dimension:out flt, 
        # dfg_start_manual do not modify this line
        pass # TODO
        #dfg_end_manual do not modify this line
        return dimension 
    # dfg_end_def do not modify this line

# dfg_end_class do not modify this line

################################################################################
# CPoint
################################################################################
# dfg_start_class do not modify this line
class CPoint : # ancestors :  CBase
    pass
#-------------------------------------------------------------------------------
    # dfg_start_def do not modify this line
    def calcDimension( self  ) : #dimension:out flt, 
        # dfg_start_manual do not modify this line
        dimension=0
        #dfg_end_manual do not modify this line
        return dimension 
    # dfg_end_def do not modify this line

# dfg_end_class do not modify this line

################################################################################
# CCircle
################################################################################
# dfg_start_class do not modify this line
class CCircle : # ancestors :  CPoint
    pass
#-------------------------------------------------------------------------------
    # dfg_start_def do not modify this line
    def calcDimension( self  ) : #dimension:out flt, 
        # dfg_start_manual do not modify this line
        self.dimension=self.radius*2
        dimension=self.dimension
        #dfg_end_manual do not modify this line
        return dimension 
    # dfg_end_def do not modify this line

# dfg_end_class do not modify this line

################################################################################
# CCompound
################################################################################
# dfg_start_class do not modify this line
class CCompound : # ancestors :  CBase
    pass
#-------------------------------------------------------------------------------
    # dfg_start_def do not modify this line
    def calcDimension( self  ) : #dimension:out flt, 
        # dfg_start_manual do not modify this line
        dimension=0
        for el in self.els :
            dimension += el.calcDimension()
        self.dimension=dimension    
        #dfg_end_manual do not modify this line
        return dimension 
    # dfg_end_def do not modify this line

# dfg_end_class do not modify this line

################################################################################
# CPicture
################################################################################
# dfg_start_class do not modify this line
class CPicture : # ancestors :  xmlBase
    pass
# dfg_end_class do not modify this line

################################################################################
# CSegment
################################################################################
# dfg_start_class do not modify this line
class CSegment : # ancestors :  CBase
    pass
#-------------------------------------------------------------------------------
    # dfg_start_def do not modify this line
    def calcDimension( self  ) : #dimension:out flt, 
        # dfg_start_manual do not modify this line
        dx=self.first.xx-self.second.xx
        dy=self.first.yy-self.second.yy
        dimension = math.sqrt( dx*dx + dy*dy )
        self.dimension = dimension
        #dfg_end_manual do not modify this line
        return dimension 
    # dfg_end_def do not modify this line

# dfg_end_class do not modify this line

################################################################################
# xml
################################################################################
# dfg_start_class do not modify this line
class xml : # ancestors :  xmlBase
    pass
# dfg_end_class do not modify this line

################################################################################
# main
################################################################################
if __name__ == u'__main__' :
    pass
